library Project1;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Classes,
  DiskInfo,
  Forms,
  Cpl,
  Registry,Windows;

{$E cpl}

var
  Okno: TForm;

{$R *.res}
{$R Aplet.res}

function OknoDiskInfo(modalne :Boolean; szerokosc :Integer) :THandle; StdCall;
const
  przes=10;
  wys=50;
var
  //Okno :TForm;
  litera :Char;
  panel :TDiskInfoPanel;
  paneleDiskInfo :array of TDiskInfoPanel;
  iloscPaneli :Byte;
begin
Result:=0;

//Tworzenie okna
if okno<>nil then Exit;
Okno:=TForm.Create(nil);
Okno.Width:=szerokosc;
Okno.Caption:='DiskInfo';

//Tworzenie paneli
iloscPaneli:=0;
for litera:='c' to 'z' do
  begin
  panel:=TDiskInfoPanel.Create(Okno);
  panel.LiteraDysku:=litera;
  if panel.Informacje.czyDyskDostepny then
    begin
    Inc(iloscPaneli);
    SetLength(paneleDiskInfo,iloscPaneli);
    panel.SetBounds(przes,przes+(iloscPaneli-1)*(wys+przes),Okno.ClientWidth-2*przes,wys);
    panel.Parent:=Okno;
    paneleDiskInfo[iloscPaneli-1]:=panel;
    end
    else
    panel.Free;
  end;

//Koncowe konfigurowanie okna
Okno.ClientHeight:=paneleDiskInfo[iloscPaneli-1].Top+paneleDiskInfo[iloscPaneli-1].Height+przes;
Okno.Position:=poScreenCenter;
if modalne then Okno.ShowModal else Okno.Show;

if not modalne then Result:=Okno.Handle else Result:=0;
end;

procedure UsunOkno; StdCall;
begin
Okno.Free;
Okno:=nil;
end;

//---------------- Aplet Panelu Sterowania ---------------//

function CPlApplet(hwndCPl :THandle; uMsg :Cardinal; lParam1, lParam2 :LongInt) :LongInt; StdCall
var lpcpli :^CPLINFO;
begin

case (uMsg) of
    CPL_INIT:     CPlApplet:=Ord(True); //True - zostanie uwzgledniony, wyslane beda kolejne komunikaty
    CPL_GETCOUNT: CPlApplet:=1; //ilosc okien dialogowych
    CPL_INQUIRE:
        begin
    	  //argumenty:
    	  //uAppNum=(UINT)lParam1 //numer okna dialogowego (w naszym przypadku tylko 0)
        lpcpli:=Pointer(lParam2); //wskaznik do CPLINFO
        lpcpli.idIcon:=101;
        lpcpli.idName:=1;
        lpcpli.idInfo:=2;
        lpcpli.lData:=0;
        //Wpisanie do idIcon, idName i idIndo CPL_DYNAMIC_RES powoduje wywolanie CPL_NEWINQUIRE przy kazdym wyswietleniu ikony, ale to zwalnia dzialanie appletu
        CPlApplet:=0;
        end;
    CPL_DBLCLK:
        begin
    	  //argumenty:
    	  //uAppNum=(UINT)lParam1 //numer okna dialogowego (w naszym przypadku tylko 0)
        //lpcpli=(LPCPLINFO)lParam2 //wskaznik do CPLINFO
 		    OknoDiskInfo(True,640); //musi byc modalne, bo inaczej zaraz zostanie zamkniete
        CPlApplet:=0;
        end;
    CPL_STOP:     CPlApplet:=0;
    CPL_EXIT:
        begin
        UsunOkno;
        CPlApplet:=0;
        end;
    else
        begin
        CPlApplet:=0;
        end;
    end;
end;

function UstalKategorie(Numer :Cardinal;DodajUsun :Boolean) :Boolean;
const
  klucz='\SOFTWARE\Microsoft\Windows\CurrentVersion\Control Panel\Extended Properties\{305CA226-D286-468e-B848-2B2E8E697B74} 2';
  sciezkaBiblioteki='%SystemRoot%\system32\project1.cpl';
var
  Rejestr :TRegistry;
  Wersja :_OSVERSIONINFO;
begin
Result:=True;

//Sprawdzanie wersji systemu Windows
Wersja.dwOSVersionInfoSize:=SizeOf(Wersja);
GetVersionEx(Wersja);
//ShowMessage('Wersja: '+IntToStr(Wersja.dwMajorVersion)+'.'+IntToStr(Wersja.dwMinorVersion));
if (Wersja.dwMajorVersion<5) or ((Wersja.dwMajorVersion=5) and (Wersja.dwMinorVersion=0))
  then Exit;

//Tworzenie zapisu w rejestrze
Rejestr:=TRegistry.Create;
Rejestr.Access:=KEY_SET_VALUE;
Rejestr.RootKey:=HKEY_LOCAL_MACHINE;

if Rejestr.OpenKey(klucz,False) then
  begin
  Result:=Rejestr.ValueExists(sciezkaBiblioteki);
  if DodajUsun then Rejestr.WriteInteger(sciezkaBiblioteki,Numer)
               else Rejestr.DeleteValue(sciezkaBiblioteki);
  Rejestr.CloseKey;
  end
  else Result:=False;

Rejestr.Free;
end;



exports OknoDiskInfo, UsunOkno, CplApplet, UstalKategorie;

begin
UstalKategorie(5,True);
end.
